<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 03.12.13 12:44
 */

namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\ApplicationRole;
use VM\ApiBundle\Entity\User;

use VM\ApiBundle\Services\PasswordEncoder;

class LoadApplicationsData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * @var array
     */
    protected $applications = array(
        array('symbol' => 'GAME', 'description' => 'Gra biznesowa', 'roles' => array(
            array('symbol' => 'ROLE_USER', 'description' => 'Zwykły użytkownik - uczeń',
                'users' => array(
                    array('name' => 'uczen1', 'surname' => 'uczen1', 'email' => 'uczen1@vm.pl'),
                    array('name' => 'uczen2', 'surname' => 'uczen2', 'email' => 'uczen2@vm.pl'),
                    array('name' => 'uczen3', 'surname' => 'uczen3', 'email' => 'uczen3@vm.pl'),
                    array('name' => 'uczen4', 'surname' => 'uczen4', 'email' => 'uczen4@vm.pl'),
                    array('name' => 'uczen5', 'surname' => 'uczen5', 'email' => 'uczen5@vm.pl'),
                    array('name' => 'uczen6', 'surname' => 'uczen6', 'email' => 'uczen6@vm.pl'),
                    array('name' => 'uczen7', 'surname' => 'uczen7', 'email' => 'uczen7@vm.pl'),
                    array('name' => 'uczen8', 'surname' => 'uczen8', 'email' => 'uczen8@vm.pl'),
                    array('name' => 'uczen9', 'surname' => 'uczen9', 'email' => 'uczen9@vm.pl'),
                    array('name' => 'uczen10', 'surname' => 'uczen10', 'email' => 'uczen10@vm.pl'),
                    array('name' => 'uczen11', 'surname' => 'uczen11', 'email' => 'uczen11@vm.pl'),
                    array('name' => 'uczen12', 'surname' => 'uczen12', 'email' => 'uczen12@vm.pl'),
                    array('name' => 'uczen13', 'surname' => 'uczen13', 'email' => 'uczen13@vm.pl'),
                    array('name' => 'uczen14', 'surname' => 'uczen14', 'email' => 'uczen14@vm.pl'),
                    array('name' => 'uczen15', 'surname' => 'uczen15', 'email' => 'uczen15@vm.pl'),
                    array('name' => 'uczen16', 'surname' => 'uczen16', 'email' => 'uczen16@vm.pl'),
                    array('name' => 'uczen17', 'surname' => 'uczen17', 'email' => 'uczen17@vm.pl'),
                    array('name' => 'uczen18', 'surname' => 'uczen18', 'email' => 'uczen18@vm.pl'),
                    array('name' => 'uczen19', 'surname' => 'uczen19', 'email' => 'uczen19@vm.pl'),
                    array('name' => 'uczen20', 'surname' => 'uczen20', 'email' => 'uczen20@vm.pl'),


                    array('name' => 'it1', 'surname' => 'it1', 'email' => 'it1@vm.pl'),
                    array('name' => 'it2', 'surname' => 'it2', 'email' => 'it2@vm.pl'),
                    array('name' => 'it3', 'surname' => 'it3', 'email' => 'it3@vm.pl'),
                    array('name' => 'it4', 'surname' => 'it4', 'email' => 'it4@vm.pl'),
                    array('name' => 'it5', 'surname' => 'it5', 'email' => 'it5@vm.pl'),
                    array('name' => 'it6', 'surname' => 'it6', 'email' => 'it6@vm.pl'),
                    array('name' => 'it7', 'surname' => 'it7', 'email' => 'it7@vm.pl'),
                    array('name' => 'it8', 'surname' => 'it8', 'email' => 'it8@vm.pl'),
                    array('name' => 'it9', 'surname' => 'it9', 'email' => 'it9@vm.pl'),
                    array('name' => 'it10', 'surname' => 'it10', 'email' => 'it10@vm.pl'),
                    array('name' => 'it11', 'surname' => 'it11', 'email' => 'it11@vm.pl'),
                    array('name' => 'it12', 'surname' => 'it12', 'email' => 'it12@vm.pl'),
                    array('name' => 'it13', 'surname' => 'it13', 'email' => 'it13@vm.pl'),
                    array('name' => 'it14', 'surname' => 'it14', 'email' => 'it14@vm.pl'),
                    array('name' => 'it15', 'surname' => 'it15', 'email' => 'it15@vm.pl'),
                    array('name' => 'it16', 'surname' => 'it16', 'email' => 'it16@vm.pl'),
                    array('name' => 'it17', 'surname' => 'it17', 'email' => 'it17@vm.pl'),
                    array('name' => 'it18', 'surname' => 'it18', 'email' => 'it18@vm.pl'),
                    array('name' => 'it19', 'surname' => 'it19', 'email' => 'it19@vm.pl'),
                    array('name' => 'it20', 'surname' => 'it20', 'email' => 'it20@vm.pl'),
                )
            ),
            array('symbol' => 'ROLE_TEACHER', 'description' => 'Użytkownik o wyższych uprawnieniach niż uczeń - nauczyciel',
                'users' => array(
                    array('name' => 'nauczyciel', 'surname' => 'nauczyciel', 'email' => 'nauczyciel@vm.pl')
                    ,array('name' => 'admin', 'surname' => 'vm', 'email' => 'it@vm.pl')
                    ,array('name' => 'prezentacja', 'surname' => 'vm', 'email' => 'prezentacja@vm.pl')
                    ,array('name' => 'Michał', 'surname' => 'Pyrka', 'email' => 'michal.pyrka@vm.pl')
                    ,array('name' => 'Mariusz', 'surname' => 'Stasiak', 'email' => 'mariusz.stasiak@vm.pl')
                    ,array('name' => 'Rafał', 'surname' => 'Ignaszewski', 'email' => 'rafal@vm.pl')
                    ,array('name' => 'Aleksandra', 'surname' => 'Grycz', 'email' => 'aleksandra.grycz@vm.pl')
                    ,array('name' => 'vm1', 'surname' => 'vm1', 'email' => 'vm1@vm.pl')
                    ,array('name' => 'vm2', 'surname' => 'vm2', 'email' => 'vm2@vm.pl')
                    ,array('name' => 'vm3', 'surname' => 'vm3', 'email' => 'vm3@vm.pl')
                    ,array('name' => 'vm4', 'surname' => 'vm4', 'email' => 'vm4@vm.pl')
                    ,array('name' => 'vm5', 'surname' => 'vm5', 'email' => 'vm5@vm.pl')
                    ,array('name' => 'vm6', 'surname' => 'vm6', 'email' => 'vm6@vm.pl')
                    ,array('name' => 'vm7', 'surname' => 'vm7', 'email' => 'vm7@vm.pl')
                    ,array('name' => 'vm8', 'surname' => 'vm8', 'email' => 'vm8@vm.pl')
                    ,array('name' => 'vm9', 'surname' => 'vm9', 'email' => 'vm9@vm.pl')
                    ,array('name' => 'vm10', 'surname' => 'vm10', 'email' => 'vm10@vm.pl')
                    ,array('name' => 'vm11', 'surname' => 'vm11', 'email' => 'vm11@vm.pl')
                    ,array('name' => 'vm12', 'surname' => 'vm12', 'email' => 'vm12@vm.pl')
                    ,array('name' => 'vm13', 'surname' => 'vm13', 'email' => 'vm13@vm.pl')
                    ,array('name' => 'vm14', 'surname' => 'vm14', 'email' => 'vm14@vm.pl')
                    ,array('name' => 'vm15', 'surname' => 'vm15', 'email' => 'vm15@vm.pl')
                    ,array('name' => 'vm16', 'surname' => 'vm16', 'email' => 'vm16@vm.pl')
                    ,array('name' => 'vm17', 'surname' => 'vm17', 'email' => 'vm17@vm.pl')
                    ,array('name' => 'vm18', 'surname' => 'vm18', 'email' => 'vm18@vm.pl')
                    ,array('name' => 'vm19', 'surname' => 'vm19', 'email' => 'vm19@vm.pl')
                    ,array('name' => 'vm20', 'surname' => 'vm20', 'email' => 'vm20@vm.pl')
                    ,array('name' => 'vm21', 'surname' => 'vm21', 'email' => 'vm21@vm.pl')
                    ,array('name' => 'vm22', 'surname' => 'vm22', 'email' => 'vm22@vm.pl')
                    ,array('name' => 'vm23', 'surname' => 'vm23', 'email' => 'vm23@vm.pl')
                    ,array('name' => 'vm24', 'surname' => 'vm24', 'email' => 'vm24@vm.pl')
                    ,array('name' => 'vm25', 'surname' => 'vm25', 'email' => 'vm25@vm.pl')
                    ,array('name' => 'vm26', 'surname' => 'vm26', 'email' => 'vm26@vm.pl')
                    ,array('name' => 'vm27', 'surname' => 'vm27', 'email' => 'vm27@vm.pl')
                    ,array('name' => 'vm28', 'surname' => 'vm28', 'email' => 'vm28@vm.pl')
                    ,array('name' => 'vm29', 'surname' => 'vm29', 'email' => 'vm29@vm.pl')
                    ,array('name' => 'vm30', 'surname' => 'vm30', 'email' => 'vm30@vm.pl')
                    ,array('name' => 'vm31', 'surname' => 'vm31', 'email' => 'vm31@vm.pl')
                    ,array('name' => 'vm32', 'surname' => 'vm32', 'email' => 'vm32@vm.pl')
                    ,array('name' => 'vm33', 'surname' => 'vm33', 'email' => 'vm33@vm.pl')
                    ,array('name' => 'vm34', 'surname' => 'vm34', 'email' => 'vm34@vm.pl')
                    ,array('name' => 'vm35', 'surname' => 'vm35', 'email' => 'vm35@vm.pl')
                    ,array('name' => 'vm36', 'surname' => 'vm36', 'email' => 'vm36@vm.pl')
                    ,array('name' => 'vm37', 'surname' => 'vm37', 'email' => 'vm37@vm.pl')
                    ,array('name' => 'vm38', 'surname' => 'vm38', 'email' => 'vm38@vm.pl')
                    ,array('name' => 'vm39', 'surname' => 'vm39', 'email' => 'vm39@vm.pl')
                    ,array('name' => 'vm40', 'surname' => 'vm40', 'email' => 'vm40@vm.pl')
                    ,array('name' => 'vm41', 'surname' => 'vm41', 'email' => 'vm41@vm.pl')
                    ,array('name' => 'vm42', 'surname' => 'vm42', 'email' => 'vm42@vm.pl')
                    ,array('name' => 'vm43', 'surname' => 'vm43', 'email' => 'vm43@vm.pl')
                    ,array('name' => 'vm44', 'surname' => 'vm44', 'email' => 'vm44@vm.pl')
                    ,array('name' => 'vm45', 'surname' => 'vm45', 'email' => 'vm45@vm.pl')
                    ,array('name' => 'vm46', 'surname' => 'vm46', 'email' => 'vm46@vm.pl')
                    ,array('name' => 'vm47', 'surname' => 'vm47', 'email' => 'vm47@vm.pl')
                    ,array('name' => 'vm48', 'surname' => 'vm48', 'email' => 'vm48@vm.pl')
                    ,array('name' => 'vm49', 'surname' => 'vm49', 'email' => 'vm49@vm.pl')
                    ,array('name' => 'vm50', 'surname' => 'vm50', 'email' => 'vm50@vm.pl')
                    ,array('name' => 'vm51', 'surname' => 'vm51', 'email' => 'vm51@vm.pl')
                    ,array('name' => 'vm52', 'surname' => 'vm52', 'email' => 'vm52@vm.pl')
                    ,array('name' => 'vm53', 'surname' => 'vm53', 'email' => 'vm53@vm.pl')
                    ,array('name' => 'vm54', 'surname' => 'vm54', 'email' => 'vm54@vm.pl')
                    ,array('name' => 'vm55', 'surname' => 'vm55', 'email' => 'vm55@vm.pl')
                    ,array('name' => 'vm56', 'surname' => 'vm56', 'email' => 'vm56@vm.pl')
                    ,array('name' => 'vm57', 'surname' => 'vm57', 'email' => 'vm57@vm.pl')
                    ,array('name' => 'vm58', 'surname' => 'vm58', 'email' => 'vm58@vm.pl')
                    ,array('name' => 'vm59', 'surname' => 'vm59', 'email' => 'vm59@vm.pl')
                    ,array('name' => 'vm60', 'surname' => 'vm60', 'email' => 'vm60@vm.pl')
                    ,array('name' => 'vm61', 'surname' => 'vm61', 'email' => 'vm61@vm.pl')
                    ,array('name' => 'vm62', 'surname' => 'vm62', 'email' => 'vm62@vm.pl')
                    ,array('name' => 'vm63', 'surname' => 'vm63', 'email' => 'vm63@vm.pl')
                    ,array('name' => 'vm64', 'surname' => 'vm64', 'email' => 'vm64@vm.pl')
                    ,array('name' => 'vm65', 'surname' => 'vm65', 'email' => 'vm65@vm.pl')
                    ,array('name' => 'vm66', 'surname' => 'vm66', 'email' => 'vm66@vm.pl')
                    ,array('name' => 'vm67', 'surname' => 'vm67', 'email' => 'vm67@vm.pl')
                    ,array('name' => 'vm68', 'surname' => 'vm68', 'email' => 'vm68@vm.pl')
                    ,array('name' => 'vm69', 'surname' => 'vm69', 'email' => 'vm69@vm.pl')
                    ,array('name' => 'vm70', 'surname' => 'vm70', 'email' => 'vm70@vm.pl')
                )
            )
        ))
    );


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $Manager)
    {
        $PasswordEncoder = new PasswordEncoder();

        foreach($this->applications as $appData)
        {
            $Application = new Application();
            $Application->setSymbol($appData['symbol']);
            $Application->setDescription($appData['description']);

            $Manager->persist($Application);

            foreach($appData['roles'] as $appRoleData)
            {
                $ApplicationRole = new ApplicationRole();
                $ApplicationRole->setApplication($Application);
                $ApplicationRole->setSymbol($appRoleData['symbol']);
                $ApplicationRole->setDescription($appRoleData['description']);

                $Manager->persist($ApplicationRole);

                foreach($appRoleData['users'] as $userData)
                {
                    $User = new User();
                    $User->setName($userData['name']);
                    $User->setSurname($userData['surname']);
                    $User->setUsername($userData['email']);
                    $User->setEmail($userData['email']);

                    $salt = md5(rand(1, 10000000));
                    $User->setSalt($salt);
                    $User->setEnabled(true);
//                    $User->setPlainPassword($PasswordEncoder->encodePassword($userData['surname'], $salt));
                    $User->setPlainPassword(md5($userData['surname']));

                    $User->addAppRole($ApplicationRole);
                    $ApplicationRole->addUser($User);

                    $Manager->persist($User);
                }
            }

            $Manager->flush();
        }
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 20;
    }
}